/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.formatter;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.html.HTMLSourceViewerConfiguration;
import com.aptana.editor.html.formatter.HTMLFormatter;
import com.aptana.editor.html.formatter.HTMLFormatterPlugin;
import com.aptana.editor.html.formatter.preferences.HTMLFormatterModifyDialog;
import com.aptana.formatter.AbstractScriptFormatterFactory;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.preferences.PreferenceKey;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.IFormatterModifyDialogOwner;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLFormatterFactory
extends AbstractScriptFormatterFactory {
    private static final PreferenceKey FORMATTER_PREF_KEY = new PreferenceKey("com.aptana.editor.html.formatter", "html.formatter");
    private static final String FORMATTER_PREVIEW_FILE = "formatterPreview.html";
    private static final String[] KEYS = new String[]{"html.formatter.formatter.indentation.size", "html.formatter.formatter.tabulation.char", "html.formatter.formatter.tabulation.size", "html.formatter.wrap.comments", "html.formatter.comments.in.separate.lines", "html.formatter.wrap.comments.length", "html.formatter.indent.excluded", "html.formatter.newline.excluded", "html.formatter.newline.exclusion.in.empty.tag", "html.formatter.line.after.element", "html.formatter.line.after.non.html", "html.formatter.line.before.non.html", "html.formatter.line.preserve", "html.formatter.spaces.trim", "html.formatter.formatter.on.off.enabled", "html.formatter.formatter.on", "html.formatter.formatter.off"};

    public PreferenceKey[] getPreferenceKeys() {
        PreferenceKey[] result = new PreferenceKey[KEYS.length];
        int i = 0;
        while (i < KEYS.length) {
            String key = KEYS[i];
            result[i] = new PreferenceKey("com.aptana.editor.html.formatter", key);
            ++i;
        }
        return result;
    }

    public IScriptFormatter createFormatter(String lineSeparator, Map<String, String> preferences) {
        return new HTMLFormatter(lineSeparator, preferences, this.getMainContentType());
    }

    public URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(FORMATTER_PREVIEW_FILE);
    }

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner) {
        return new HTMLFormatterModifyDialog(dialogOwner, (IScriptFormatterFactory)this);
    }

    public SourceViewerConfiguration createSimpleSourceViewerConfiguration(ISharedTextColors colorManager, IPreferenceStore preferenceStore, ITextEditor editor, boolean configureFormatter) {
        return new HTMLSourceViewerConfiguration(preferenceStore, (AbstractThemeableEditor)editor);
    }

    public PreferenceKey getFormatterPreferenceKey() {
        return FORMATTER_PREF_KEY;
    }

    public IPreferenceStore getPreferenceStore() {
        return HTMLFormatterPlugin.getDefault().getPreferenceStore();
    }

    public Object getPartitioningConfiguration() {
        return HTMLSourceConfiguration.getDefault();
    }

    public boolean canConsumePreviousIndent() {
        return false;
    }

    protected IEclipsePreferences getEclipsePreferences() {
        return InstanceScope.INSTANCE.getNode("com.aptana.editor.html");
    }

    protected String getFormatterTabPolicy(Map<String, String> preferences) {
        return preferences.get("html.formatter.formatter.tabulation.char");
    }

    protected String getFormatterTabSizeKey() {
        return "html.formatter.formatter.tabulation.size";
    }

    protected int getEditorTabSize() {
        return EditorUtil.getSpaceIndentSize((String)HTMLPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected int getDefaultEditorTabSize() {
        return EditorUtil.getDefaultSpaceIndentSize((String)HTMLPlugin.getDefault().getBundle().getSymbolicName());
    }
}

